#include <Arduino.h>
#include "peripheral_config.h"

// Variables globales
uint16_t  adc_7;
bool run = false, start_saving = false, data_saved = false, sending = false, saving = false, cambiar_carga = false;
float s_ref[N_SAVED], s_y[N_SAVED], s_u[N_SAVED];

void setup() {
  // Llamada a funciones de configuración
  GPIO_setup();
  ADC_setup();
  PWM_setup();
  Serial.begin(115200);
}

void loop() {

  static bool bk, bkm1 = true, b2k, b2km1 = true;
  bk = PIO_Get(PIO_BOTON,PIO_INPUT,B_START);
  b2k = PIO_Get(PIO_BOTON,PIO_INPUT,B_STOP);
  if(bk == 1 && bkm1 == 0 && !sending){
    // Se produjo una pulsación del botón de incio/parada
    run = !run;
    if(run && !saving){ // Si se inicia que guarde el transitorio inicial
      start_saving = true;
    }
  }

  if(b2k == 1 && b2km1 == 0 && run && !saving && !sending){ //Verifico primero que no se esté guardando p
    // Se produjo una pulsación del botón de cambio de carga
      start_saving = true;
      cambiar_carga = true;
  }
  b2km1 = b2k;
  bkm1 = bk;

  if(data_saved){  //Si se llenaron los buffers de las variables internas, lo envía al ESP8266
    sending = true;
    Serial.print("start");
    Serial.print('\n');
    for(uint16_t i = 0 ; i < N_SAVED ; i++){
      Serial.print(s_ref[i],4);
      Serial.print(',');
      Serial.print(s_y[i],4);
      Serial.print(',');
      Serial.print(s_u[i],4);
      Serial.print('\n');
      delay(10);
    }
    Serial.print("end");
    Serial.print('\n');
    sending = false;
    data_saved = false;
  }

}


void ADC_Handler(void){
  /*---------------------------------------------------------------------*/
  /* Definir variables necesarias para el cálculo de la acción de control*/
  


  /*---------------------------------------------------------------------*/
  /*---------------------------------------------------------------------*/
  static float yk = 0, uk = 0, ref = 0;
  static uint16_t index = 0, counter_N = 0, counter_ref1 = 0, counter_carga = 0;
  
  // Primero se verifica si la bandera de fin de conversión corresponde al canal 7 del ADC
  // Y si corresponde ejecutar el cálculo de la acción de control según N_Tpwm
  if(ADC->ADC_ISR & ADC_ISR_EOC7){  
    adc_7 = ADC->ADC_CDR[7]; //Se lee el valor del registro de resultado de conversión del canal 7
    PIO_Set(PIO_LED,LED_1); // Se enciende el LED de estado 1

    //El siguiente código se ejecuta solamente si se dio la señal de inicio
    if(run){

      // Control de cambio de carga
      // Si se presiona el botón, el sistema conecta a los 5 ms la segunda carga, y la desconecta a los 15 ms
      if(cambiar_carga){
        counter_carga++;
        if(counter_carga > 200 && counter_carga < 600){
          PIO_Set(PIO_CARGA, CAMBIO_CARGA);
        }else{
          PIO_Clear(PIO_CARGA, CAMBIO_CARGA);
        }
        if(counter_carga > 1000)
          cambiar_carga = false; // Se sale del estado de cambio de carga.
      }else{
        counter_carga = 0;
        PIO_Clear(PIO_CARGA,CAMBIO_CARGA);
      }

      // Variación de referencia en rampa ascendente
      // ---------------------------------------------------------------------------------------
      // --------------------------------ATENCION!!!!!------------------------------------------
      // Esto debe modificarse para obtener la variación de referencia solicitada
      // en la guía de laboratorio.

      counter_ref1++; // Se cuenta desde 1
      if(ref < REF50){ 
        ref = ref + delta_Ref;
      }else{ 
        ref = REF50;								 
      }

      // ESCALON de referencia
      if(counter_ref1 >= 600){	 	// Si el contador alcanzó t = 600*Ts, la ref.
      ref = REF80; 
      counter_ref1 = 1000;
      }
      

      //------------ Normalización del valor del ADC ---------------------------------                 
      yk = ((float) adc_7)/3276.f;

      /*------------------------------------------------------------*/
      /* Escribir el código para el cálculo de la acción de control */
      uk = 0.44f;

      /*------------------------------------------------------------*/
      /*------------------------------------------------------------*/


      PWM_update_duty_cycle(uk); // Actualización de la acción de control
      PIO_Clear(PIO_LED,LED_1); //  El led se apaga al finalizar el cálculo
      if(start_saving){
        // Si se da la bandera de iniciar el guardado de datos, se limpia dicha bandera,
        // se activa la bandera de guardado en progreso, y se inicializa el indice para el vector de datos en 0
        start_saving = 0;
        saving = 1;
        index = 0;
      }
      // Si se dio la señal de guardado de variables, se guardan utilizando el indice hasta que los arreglos estén llenos
      if(saving){
        PIO_Set(PIO_LED,LED_2);
        
        s_ref[index] = ref;
        s_y[index] = yk;
        s_u[index] = uk;
        index++;
        if(index>=N_SAVED){
          saving = 0;
          data_saved = 1;
        }
      } else {
        PIO_Clear(PIO_LED,LED_2);
      }

    } else { // Si el convertidor no inició, o se presionó el boton de parada, se limpian las variables involucradas
      /*------------------------------------------------------------------------------*/
      /* Asignar 0 a las variables utilizadas para el cálculo de la acción de control */
      /* Ej.: valores de errores y acciones de control pasadas */


      /*------------------------------------------------------------------------------*/
      /*------------------------------------------------------------------------------*/
      uk = 0;
      index = 0;
      ref = 0.f;
      counter_ref1 = 0;
      PWM_update_duty_cycle(0);
      PIO_Clear(PIO_LED,LED_2);
      if(saving){
        saving = false;
        cambiar_carga = false;
      }
    }
  }
}

